/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.condition;

import com.google.common.collect.ImmutableSet;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProviderSerializer;
import dev.toma.gunsrpg.common.quests.trigger.Trigger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public class QuestConditionProviderType<Q extends IQuestConditionProvider<?>> {
    private final ResourceLocation id;
    private final IQuestConditionProviderSerializer<Q> serializer;
    private final BiFunction<QuestConditionProviderType<Q>, CompoundNBT, Q> fromNbtReader;
    private final Set<Trigger> triggerSet;
    private final boolean failsQuest;

    QuestConditionProviderType(ResourceLocation id, IQuestConditionProviderSerializer<Q> serializer, BiFunction<QuestConditionProviderType<Q>, CompoundNBT, Q> fromNbtReader, boolean failsQuest, Trigger ... triggers) {
        this.id = id;
        this.serializer = serializer;
        this.fromNbtReader = fromNbtReader;
        this.failsQuest = failsQuest;
        this.triggerSet = triggers.length == 0 ? Collections.emptySet() : ImmutableSet.copyOf(Arrays.asList(triggers));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public IQuestConditionProviderSerializer<Q> getSerializer() {
        return this.serializer;
    }

    public Q fromNbt(CompoundNBT nbt) {
        return (Q)((IQuestConditionProvider)this.fromNbtReader.apply(this, nbt));
    }

    public boolean shouldFailQuest() {
        return this.failsQuest;
    }

    public Set<Trigger> getTriggerSet() {
        return this.triggerSet;
    }
}

